//
//  FJDItemsInFolderWindowController_UserInterface.m
//  FJDItemsInFolderWindow
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJDItemsInFolderWindowController.h"
#import "FJDSortedArrayController.h"


NSString *FJDItemsInFolderToolbarNewItemIdentifier			= @"FJDItemsInFolderToolbarNewItemIdentifier";
NSString *FJDItemsInFolderToolbarNewFolderIdentifier		= @"FJDItemsInFolderToolbarNewFolderIdentifier";
NSString *FJDItemsInFolderToolbarNewIdentifier				= @"FJDItemsInFolderToolbarNewIdentifier";
NSString *FJDItemsInFolderToolbarDeleteItemIdentifier		= @"FJDItemsInFolderToolbarDeleteItemIdentifier";
NSString *FJDItemsInFolderToolbarDeleteFolderIdentifier		= @"FJDItemsInFolderToolbarDeleteFolderIdentifier";
NSString *FJDItemsInFolderToolbarDeleteIdentifier			= @"FJDItemsInFolderToolbarDeleteIdentifier";
NSString *FJDItemsInFolderToolbarPreviousItemIdentifier		= @"FJDItemsInFolderToolbarPreviousItemIdentifier";
NSString *FJDItemsInFolderToolbarNextItemIdentifier			= @"FJDItemsInFolderToolbarNextItemIdentifier";
NSString *FJDItemsInFolderToolbarPreviousFolderIdentifier	= @"FJDItemsInFolderToolbarPreviousFolderIdentifier";
NSString *FJDItemsInFolderToolbarNextFolderIdentifier		= @"FJDItemsInFolderToolbarNextFolderIdentifier";
NSString *FJDItemsInFolderToolbarDeselectSortIdentifier		= @"FJDItemsInFolderToolbarDeselectSortIdentifier";
NSString *FJDItemsInFolderToolbarSearchItemIdentifier		= @"FJDItemsInFolderToolbarSearchItemIdentifier";


@implementation FJDItemsInFolderWindowController (UserInterface)

#pragma mark Private action methods

- (IBAction)clearPredicate:(id)sender
{
	[searchField setStringValue:@""];
	[searchField performClick:sender];
}

#pragma mark Methods to set up toolbar

// --- set up toolbar. subclass may invoke this method in windowDidLoad: if toolbar is needed. ---

- (void)setupToolbarWithIdentifier:(NSString *)identifier
{
	NSToolbar *toolbar = [[NSToolbar alloc] initWithIdentifier:identifier];
    [toolbar setAllowsUserCustomization:YES];
    [toolbar setAutosavesConfiguration:YES];
    [toolbar setDisplayMode:NSToolbarDisplayModeDefault];
	[toolbar setDelegate:self];
	[[self window] setToolbar:toolbar];
	[toolbar release];
}


#pragma mark Methods delegated by NSToolbar

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
	NSString *label, *paletteLabel, *toolTip;
	
	if ([itemIdentifier isEqual:FJDItemsInFolderToolbarNewIdentifier]) {
		
		// --- New ---
		label = NSLocalizedStringFromTable(@"New", @"CoreDataLocalizable", @"toolbarItem.newFolder.label");
		paletteLabel = NSLocalizedStringFromTable(@"New", @"CoreDataLocalizable", @"toolbarItem.newFolder.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Add New", @"CoreDataLocalizable", @"toolbarItem.newFolder.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNewIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(insert:)];
	
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarNewItemIdentifier]) {
		
		// --- New Item --- 
		NSString *name = [[self localizedItemName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Add New %@", @"CoreDataLocalizable", @"toolbarItem.newItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNewItemIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(insertItem:)];
	
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarNewFolderIdentifier]) {
		
		// --- New Folder ---
		NSString *name = [[self localizedFolderName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newFolder.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Add New %@", @"CoreDataLocalizable", @"toolbarItem.newFolder.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNewFolderIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(insertFolder:)];
	
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarDeleteIdentifier]) {
		
		//  --- Delete ---
		label = NSLocalizedStringFromTable(@"Delete", @"CoreDataLocalizable", @"toolbarItem.delete.label");
		paletteLabel = NSLocalizedStringFromTable(@"Delete", @"CoreDataLocalizable", @"toolbarItem.delete.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Delete Selection", @"CoreDataLocalizable", @"toolbarItem.deleteItem.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarDeleteIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(delete:)];
	
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarDeleteItemIdentifier]) {
	
		// --- Delete Item ---
		NSString *name = [[self localizedPluralItemName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete Selected %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarDeleteItemIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(deleteItem:)];
		
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarDeleteFolderIdentifier]) {
		
		// --- Delete Folder ---
		NSString *name = [[self localizedPluralFolderName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete Selected %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarDeleteFolderIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(deleteFolder:)];
		
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarPreviousItemIdentifier]) {
		
		// --- Select Previous Item ---
		NSString *name = [[self localizedItemName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarPreviousItemIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectPreviousItem:)];
	
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarNextItemIdentifier]) {
		
		// --- Select Next Item ---
		NSString *name = [[self localizedItemName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNextItemIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectNextItem:)];
	
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarPreviousFolderIdentifier]) {
		
		// --- Select Previous Folder ---
		NSString *name = [[self localizedFolderName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousFolder.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousFolder.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarPreviousFolderIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectPreviousFolder:)];
	
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarNextFolderIdentifier]) {
		
		// --- Select Next Folder ---
		NSString *name = [[self localizedFolderName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextFolder.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextFolder.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNextFolderIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectNextFolder:)];
		
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarDeselectSortIdentifier]) {
		// Deselect sort
		label = NSLocalizedStringFromTable(@"Deselect Sort", @"CoreDataLocalizable", @"toolbarItem.deselectSort.label");
		paletteLabel = NSLocalizedStringFromTable(@"Deselect Sort", @"CoreDataLocalizable", @"toolbarItem.deselectSort.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Revert Sort Order to Default Settings", @"CoreDataLocalizable", @"toolbarItem.deselectSort.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(deselectSort:)];
		
	} else if ([itemIdentifier isEqual:FJDItemsInFolderToolbarSearchItemIdentifier]) {
		// Search
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Search", @"CoreDataLocalizable", @"toolbar.search.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Search", @"CoreDataLocalizable", @"toolbar.search.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Show Only Items Containing String Specified", @"CoreDataLocalizable", @"toolbar.search.toolTip")];
//		[toolbarItem setView:searchView];
//		[toolbarItem setMinSize:NSMakeSize(60, NSHeight([searchView frame]))];
//		[toolbarItem setMaxSize:NSMakeSize(210, NSHeight([searchView frame]))];
		[toolbarItem setView:searchField];
		[toolbarItem setMinSize:NSMakeSize(60, NSHeight([searchField frame]))];
		[toolbarItem setMaxSize:NSMakeSize(210, NSHeight([searchField frame]))];
		[toolbarItem setVisibilityPriority:NSToolbarItemVisibilityPriorityHigh];
		
		NSMenuItem *menuItem = [[NSMenuItem alloc] initWithTitle:NSLocalizedStringFromTable(@"Clear Search", @"CoreDataLocalizable", @"toolbar.search.menuRepresentationTitle") 
														  action:@selector(clearPredicate:)
												   keyEquivalent:@""];
		[toolbarItem setMenuFormRepresentation:menuItem];
		[menuItem autorelease];
//		
	} else {
		toolbarItem = nil;
	}
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:FJDItemsInFolderToolbarNewItemIdentifier,
		FJDItemsInFolderToolbarNewFolderIdentifier,
		FJDItemsInFolderToolbarDeleteIdentifier,
		NSToolbarSeparatorItemIdentifier,
		FJDItemsInFolderToolbarPreviousItemIdentifier,
		FJDItemsInFolderToolbarNextItemIdentifier,
		FJDItemsInFolderToolbarPreviousFolderIdentifier,
		FJDItemsInFolderToolbarNextFolderIdentifier,
		NSToolbarSeparatorItemIdentifier,
		FJDItemsInFolderToolbarDeselectSortIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		FJDItemsInFolderToolbarSearchItemIdentifier,
		nil	
		];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:FJDItemsInFolderToolbarNewItemIdentifier,
		FJDItemsInFolderToolbarNewFolderIdentifier,
		FJDItemsInFolderToolbarNewIdentifier,
		FJDItemsInFolderToolbarDeleteItemIdentifier,
		FJDItemsInFolderToolbarDeleteFolderIdentifier,
		FJDItemsInFolderToolbarDeleteIdentifier,
		FJDItemsInFolderToolbarPreviousItemIdentifier,
		FJDItemsInFolderToolbarNextItemIdentifier,
		FJDItemsInFolderToolbarPreviousFolderIdentifier,
		FJDItemsInFolderToolbarNextFolderIdentifier,
		FJDItemsInFolderToolbarDeselectSortIdentifier,
		FJDItemsInFolderToolbarSearchItemIdentifier,
		NSToolbarSeparatorItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		NSToolbarSpaceItemIdentifier,
		nil];
}

- (void)toolbarDidRemoveItem:(NSNotification *)notification
{
	NSToolbarItem *removedItem = [[notification userInfo] objectForKey:@"item"];
	
	if ([[removedItem itemIdentifier] isEqual:FJDItemsInFolderToolbarSearchItemIdentifier]) {
		
		// If ``search'' toolbar item is removed, clear search word.
		[self clearPredicate:nil];
	}
}

#pragma mark Methods implementing NSToolbarItemValidation informal protocol
- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem
{
	if ([theItem action] == @selector(insert:)) {
		NSResponder *firstResponder = [[self window] firstResponder];
		if (firstResponder == itemsTableView) {
			return [itemsController canInsert];
		} else if (firstResponder == foldersTableView) {
			return [foldersController canInsert];
		}
		return NO;
	} else if ([theItem action] == @selector(insertItem:)) {
		return [itemsController canInsert];
	} else if ([theItem action] == @selector(insertFolder:)) {
		return [foldersController canInsert];
	} else if ([theItem action] == @selector(delete:)) {
		NSResponder *firstResponder = [[self window] firstResponder];
		if (firstResponder == itemsTableView) {
			return [itemsController canRemove];
		} else if (firstResponder == foldersTableView) {
			return [foldersController canRemove];
		}
		return NO;
	} else if ([theItem action] == @selector(deleteItem:)) {
		return [itemsController canRemove];
	} else if ([theItem action] == @selector(deleteFolder:)) {
		return [foldersController canRemove];
	} else if ([theItem action] == @selector(selectPreviousItem:)) {
		return [itemsController canSelectPrevious];
	} else if ([theItem action] == @selector(selectNextItem:)) {
		return [itemsController canSelectNext];
	} else if ([theItem action] == @selector(selectPreviousFolder:)) {
		return [foldersController canSelectPrevious];
	} else if ([theItem action] == @selector(selectNextFolder:)) {
		return [foldersController canSelectNext];
	} else if ([theItem action] == @selector(deselectSort:)) {
		return [itemsController isSortedUsingDefaultDescriptors] == NO;
		
	} else if ([FJDCoreDataWindowController instancesRespondToSelector:@selector(validateToolbarItem:)]) {
		return [super validateToolbarItem:theItem];
	}
	return YES;
}

#pragma mark Methods implementing NSMenuValidation informal protocol
- (BOOL)validateMenuItem:(id <NSMenuItem>)theItem
{
	if ([theItem action] == @selector(insert:)) {
		NSResponder *firstResponder = [[self window] firstResponder];
		if (firstResponder == itemsTableView) {
			return [itemsController canInsert];
		} else if (firstResponder == foldersTableView) {
			return [foldersController canInsert];
		}
		return NO;
	} else if ([theItem action] == @selector(insertItem:)) {
		return [itemsController canInsert];
	} else if ([theItem action] == @selector(insertFolder:)) {
		return [foldersController canInsert];
	} else if ([theItem action] == @selector(delete:)) {
		NSResponder *firstResponder = [[self window] firstResponder];
		if (firstResponder == itemsTableView) {
			return [itemsController canRemove];
		} else if (firstResponder == foldersTableView) {
			return [foldersController canRemove];
		}
		return NO;
	} else if ([theItem action] == @selector(deleteItem:)) {
		return [itemsController canRemove];
	} else if ([theItem action] == @selector(deleteFolder:)) {
		return [foldersController canRemove];
	} else if ([theItem action] == @selector(selectPreviousItem:)) {
		return [itemsController canSelectPrevious];
	} else if ([theItem action] == @selector(selectNextItem:)) {
		return [itemsController canSelectNext];
	} else if ([theItem action] == @selector(selectPreviousFolder:)) {
		return [foldersController canSelectPrevious];
	} else if ([theItem action] == @selector(selectNextFolder:)) {
		return [foldersController canSelectNext];
	} else if ([theItem action] == @selector(deselectSort:)) {
		return [itemsController isSortedUsingDefaultDescriptors] == NO;
	} else if ([theItem action] == @selector(clearPredicate:)) {
		return ([[searchField stringValue] isEqualToString:@""] == NO);
		
	} else if ([FJDCoreDataWindowController instancesRespondToSelector:@selector(validateMenuItem:)]) {
		return [super validateMenuItem:theItem];
	}
	return YES;
}

#pragma mark Action mehtods

- (IBAction)insert:(id)sender
{
	NSResponder *firstResponder = [[self window] firstResponder];
	if (firstResponder == itemsTableView) {
		[itemsController insert:sender];
	} else if (firstResponder == foldersTableView) {
		[foldersController insert:sender];
	}
}

- (IBAction)insertItem:(id)sender
{
	[itemsController insert:sender];
}

- (IBAction)insertFolder:(id)sender
{
	[foldersController insert:sender];
}

- (IBAction)delete:(id)sender
{
	NSResponder *firstResponder = [[self window] firstResponder];
	if (firstResponder == itemsTableView) {
		[itemsController remove:sender];
	} else if (firstResponder == foldersTableView) {
		[foldersController remove:sender];
	}
}

- (IBAction)deleteItem:(id)sender
{
	[itemsController remove:sender];
}

- (IBAction)deleteFolder:(id)sender
{
	[foldersController remove:sender];
}

- (IBAction)selectPreviousItem:(id)sender
{
	[itemsController selectPrevious:sender];
}

- (IBAction)selectNextItem:(id)sender
{
	[itemsController selectNext:sender];
}

- (IBAction)selectPreviousFolder:(id)sender
{
	[foldersController selectPrevious:sender];
}

- (IBAction)selectNextFolder:(id)sender
{
	[foldersController selectNext:sender];
}

- (IBAction)deselectSort:(id)sender
{
	[foldersController setSortDescriptors:[foldersController defaultSortDescriptors]];
	[itemsController setSortDescriptors:[itemsController defaultSortDescriptors]];
}

- (IBAction)find:(id)sender
{
	[[self window] makeFirstResponder:searchField];
}

@end